unit Mainform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, LDialogs, StdCtrls {$IFDEF NEVER} , Dialogs, BlahBlah {$ENDIF} ;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    CheckBox1: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
    procedure WndProc(var Message: TMessage); override;
    procedure ApplicationActivate(Sender: TObject);
    procedure ApplicationDeactivate(Sender: TObject);
    procedure ManageStayOnTop;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses Unit2, Unit3;

procedure TForm1.ApplicationActivate(Sender: TObject);
begin
  BringWindowToTop(GetWindowOnTop(hInstance));
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.HelpFile := 'LDIALOGS.HLP';
  Application.OnActivate := ApplicationActivate; 
  Application.OnDeactivate := ApplicationDeactivate;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Application.HelpContext(2);
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  OpenDialog: TOpenDialog;
begin
  OpenDialog := TOpenDialog.Create(nil);
  OpenDialog.HelpContext := 5;
  OpenDialog.Options := [ofShowHelp];
  OpenDialog.Execute;
  OpenDialog.Free;
end;

procedure TForm1.WndProc(var Message: TMessage);
begin
  CheckHelp(Message);
  inherited WndProc(Message);
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  Form2: TForm2;
begin
  Form2 := TForm2.Create(nil);
  Form2.ShowModal;
  Form2.Free;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  Form3: TForm3;
begin
  Form3 := TForm3.Create(nil);
  Form3.ShowModal;
  Form3.Free;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  ManageStayOnTop;
end;

procedure TForm1.ApplicationDeactivate(Sender: TObject);
begin
  if not Application.Terminated then
    ManageStayOnTop;
end;

procedure TForm1.ManageStayOnTop;
var
  WndInsertAfter: HWnd;
begin
  if CheckBox1.Checked then
    WndInsertAfter := HWND_TOPMOST
  else
    WndInsertAfter := HWND_NOTOPMOST;
  SetWindowPos(Application.Handle, WndInsertAfter, 0, 0, 0, 0, SWP_NOMOVE or
    SWP_NOSIZE or SWP_NOACTIVATE);
  SetWindowPos(Handle, WndInsertAfter, 0, 0, 0, 0, SWP_NOMOVE or
    SWP_NOSIZE or SWP_NOACTIVATE);
end;

end.
